#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Recursive CirclesMod01.fsh  by  isaacchurchill   
//https://www.shadertoy.com/view/slGBDw
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define ANIMATE
#define NEST_DEPTH 7
#define SIZE_RATIO 0.45;

vec4 nestedCircles(vec2 uv)
{
    const vec4 outsideColor = vec4(0.2, 0.2, 0.25, 1.0);
    const vec4 circleColors[4] = vec4[](
        vec4(1.0, 0.9, 0.0, 1.0),
        vec4(1.0, 0.0, 0.0, 1.0),
        vec4(0.0, 1.0, 0.0, 1.0),
        vec4(0.0, 0.0, 1.0, 1.0));
    const int circleChildren[12] = int[](
        1, 2, 3,
        2, 3, 0,
        3, 0, 1,
        0, 1, 2);
    const vec2 topLeftOffset = vec2(-0.45, 0.3);
    const vec2 topRightOffset = vec2(0.45, 0.3);
    const vec2 bottomOffset = vec2(0.0, -0.5);


    vec2 pos = uv;
    float scale = 1.0;
    if (length(pos) * scale <= 1.0) {
        int currentColor = 0;
        for (int i = 0; i < NEST_DEPTH; i++) {
            #ifdef ANIMATE
            float theta = i % 2 == 0 ? iTime * 0.5 : iTime * -0.5;
            mat2 rotMat = mat2(
                cos(theta), -sin(theta),
                sin(theta), cos(theta));
            pos *= rotMat;
            #endif
            
            float smallerScale = scale * SIZE_RATIO;
            if (length(pos - topLeftOffset * scale) <= smallerScale) {
                pos -= topLeftOffset * scale;
                scale = smallerScale;
                currentColor = circleChildren[currentColor * 3];
            } else if (length(pos - topRightOffset * scale) <= smallerScale) {
                pos -= topRightOffset * scale;
                scale = smallerScale;
                currentColor = circleChildren[currentColor * 3 + 1];
            } else if (length(pos - bottomOffset * scale) <= smallerScale) {
                pos -= bottomOffset * scale;
                scale = smallerScale;
                currentColor = circleChildren[currentColor * 3 + 2];
            } else {
                break;
            }
        }
        float gradient = 1.0 - 0.5 * dot(pos, pos) / (scale * scale);
        return circleColors[currentColor] * gradient;
    } else {
        float gradient = min(dot(pos, pos) * 0.25, 1.0);
        return outsideColor * gradient;
    }
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    fragColor = nestedCircles(uv);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

